#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int N, K;
    std::cin >> N >> K;
    std::vector<int> X(N), V(N);
    for (int i = 0; i < N; i++) {
        std::cin >> X[i] >> V[i];
    }

    int cnt = 0;
    std::vector<std::pair<int, int>> changes(N * N);
    for (int i = 0; i < N; i++) {
        for (int j = i + 1; j < N; j++) {
            changes[cnt++] = {(X[i] - X[j]) / (V[i] - V[j]), 1};
            changes[cnt++] = {(X[j] - X[i]) / (V[j] - V[i]), -1};
        }
    }

    std::sort(changes.begin(), changes.end());

    int res = 0;
    for (int i = 0; i < cnt; i++) {
        res += changes[i].second;
        if (res >= K) {
            std::cout << changes[i].first << "\n";
            break;
        }
    }

    return 0;
}